/*
    REMTEST Editor Skeleton

    Marc Wolfgram,  4/29/91  0:34:41
    ---------------------------------------------------------------
    v1.0a1
*/
#pragma noroot
#include <foundation.h>
#include <event.h>
#include <resources.h>

#define SMALLBUNDLE 26L


extern EventRecordPtr fEventPtr;

word    ~TOOLERROR,                 /* declared for ORCA/C toolerror()      */
        ~USERID,                    /* declared for ORCA library use        */
        edUserID,
        edResFileID,
        shResFileID;

fPrivateDataRec PrivPB;
fResDataRec     DataPB;
fResData2Rec    Data2PB;
fGetFileRec     FilePB;
fResNameRec     NamePB;
fResRefRec      RefPB;
fResLinkRec     LinkPB;
fResCopyRec     CopyPB;

word REM_OPEN(fOpenRecPtr p)
{
word retVal, retErr;
rFooBarHndl FooBarH;
ParamListHndl theWindow;
Handle      private;

    if (p->resType != rBundle)      /* first see if we edit this type...    */
        return fErrTypeInvalid;     /* multitype editors would case more    */

    if (!p->resID) {                /* if no ID has been passed make one... */

        CopyPB.pCount = 5;          /* in this case copy a default bundle   */
        CopyPB.resType = rBundle;
        CopyPB.resID = 2L;
        CopyPB.newID = 0L;
        CopyPB.attr = 0;
        CopyPB.resFileID = edResFileID;
        retErr = fCopyResource(&CopyPB);
        if (retErr)
            return fErrAddingResource;

        p->resID = CopyPB.resID;

    }
    DataPB.pCount = 3;              /* set up a this can be set up now because the   */
    DataPB.resType = rBundle;       /* add and load callbacks can use the   */
    DataPB.resID = p->resID;        /* same parameter block...              */
    retErr = fLoadResource(&DataPB);
    if (retErr)
        return fErrLoadingResource;

        FooBarH = (Handle) DataPB.resData;
    }

    LoadHandle(rWinParam1, 1L, (Handle) theWindow);
    LoadHandle(rPString, 1L, (Handle) theWindowTitle);
    HLock(theWindowTitle);

    winP = NewWindow2(*theWindowTitle, 0L, 0L, 0L, 1, theWindow, 0x800e);

    private = NewHandle(4L, edUserID, 0x0018, 0L); /* or whatever size... */

    PrivPB.pCount = 6;
    PrivPB.winPtr = winP;
    PrivPB.remSignature = 0;
    PrivPB.Data = private;
    PrivPB.groupSignature = 0x0020;
    PrivPB.resType = rFooBar;
    PrivPB.resID = p->resID;
    fInitializePrivateData(&PrivPB);

    return  0;
}

word REM_CLOSE(fSessionRecPtr p)
{
GrafPortPtr winP;

    winP = GetPort();           /* Close needs this - guaranteed correct */

    PrivPB.pCount = 3;
    PrivPB.winPtr = winP;
    fGetPrivateData(&PrivPB);
    DisposeHandle(PrivPB.Data);


    return  0;
}

word REM_WRITE(fSessionRecPtr p)
{
    return  0;
}

word REM_EVENT(fEventRecPtr p)
{
    return  0;
}

word REM_ACTIVATE(fActivateRecPtr pb)
{
    return  0;
}

word REM_GETLINK(fLinkRecPtr p)
{
    return  0;
}

word REM_VIDMODE(fEventRecPtr p)
{
    return  0;
}

word REM_PRINT(fPrintRecPtr p)
{
    return  0;
}

/*
    REM_STARTUP is called only when the REM is first loaded.

    The REM should do whatever it needs to do to setup globals, etc.

    This is the only time when the Foundation and REM resource file
    ID's are passed.  Also, the REM's specific memory manager ID is
    passed here - READ THE WARNING IN REM_SHUTDOWN!

    Marc Wolfgram,  4/13/91 13:06:37
    ---------------------------------------------------------------
*/
word REM_STARTUP(fStartStopRecPtr p)
{
    ~USERID = edUserID = p->edUserID;
    edResFileID = p->edResFileID;
    shResFileID = p->shResFileID;
    return  0;
}

/*
    REM_SHUTDOWN is called when an editor is unloaded.

    WARNING: The REM must release any memory allocated at startup during
             the shutdown call.  There is no guarantee that once the editor
             is released that it will be reloaded.

    Marc Wolfgram,  4/29/91  0:33:56
    ---------------------------------------------------------------
*/
word REM_SHUTDOWN(fStartStopRecPtr p)
{
    return  0;
}

/*--------------------------------------
    LoadHandle - loads a resource from the editor's resource fork and
    returnes a detached handle for use by tool calls.

    Marc Wolfgram,  9/19/91 20:46:58
*/
word LoadHandle(word resType, long resID, Handle resData)
{
word retErr;

    DataPB.pCount = 5;
    DataPB.resType = resType;
    DataPB.resID = resID;
    DataPB.resFileID = edResFileID;
    retErr = fLoadResource(&DataPB);
    resData = DataPB.resData;

    RefPB.pCount = 3;
    RefPB.resType = resType;
    RefPB.resID = resID;
    RefPB.resFileID = edResFileID;
    fDetachResource(&RefPB);

    return retErr;
}
